import nltk
from nltk.probability import FreqDist
from nucular import Nucular
from collections import defaultdict

SIMPLE_ARCHIVE = 'c:/users/vaidhy/Development/scipy/archive/simple'

def getResults(w):
    archive = Nucular.Nucular(SIMPLE_ARCHIVE)
    q = archive.Query()
    q.anyWord(w)
    results = q.resultDictionaries()[0]
    return results

def extractEntityNames(t):
    entity_names = defaultdict(set)
    
    if hasattr(t, 'node') and t.node:
        if t.node == 'PERSON':
            entity_names['PERSON'].add(' '.join([child[0] for child in t]))
        elif t.node == 'LOCATION':
            entity_names['LOCATION'].add(' '.join([child[0] for child in t]))
        elif t.node == 'GPE':
            entity_names['GPE'].add(' '.join([child[0] for child in t]))            
        else:
            for child in t:
                entities = extractEntityNames(child)
                entity_names['PERSON'].update(entities['PERSON'])
                entity_names['LOCATION'].update(entities['LOCATION'])
                entity_names['GPE'].update(entities['GPE'])
                
    return entity_names
    
def findNE(w):
    results = getResults(w)
    sentences = nltk.sent_tokenize(results['content'])
    tokenized_sentences = [nltk.word_tokenize(sentence) for sentence in sentences[:5]]
    tagged_sentences = [nltk.pos_tag(sentence) for sentence in tokenized_sentences]
    chunked_sentences = nltk.batch_ne_chunk(tagged_sentences, binary=False)

    entity_names = defaultdict(set)
    
    for tree in chunked_sentences:
        entities = extractEntityNames(tree)
        entity_names['PERSON'].update(entities['PERSON'])
        entity_names['LOCATION'].update(entities['LOCATION'])
        entity_names['GPE'].update(entities['GPE'])
            
    print "People: " + str(entity_names['PERSON'])
    print "Location: " + str(entity_names['LOCATION'])
    print "Others: " + str(entity_names['GPE'])
        
        
if __name__ == "__main__":   
    findNE('parseltongue')
